// ==============================================================================
// main.c
// firmware for a MIDI device based on the gnusb - OPEN SOURCE USB SENSOR BOX
// with code adapted from  	V-USB MIDI device on Low-Speed USB
//							* Author: Martin Homuth-Rosemann
//							http://cryptomys.de/horo/V-USB-MIDI/index.html
//

// License:
// The project is built with AVR USB driver by Objective Development, which is
// published under an own licence based on the GNU General Public License (GPL).
// gnusb is also distributed under this enhanced licence. See Documentation.
//
// target-cpu: ATMega16 @ 12MHz
// created 2007-01-28 Michael Egger me@anyma.ch
// version 2011-10-23 Michael Egger me@anyma.ch
//
// ==============================================================================

// ==============================================================================
// CONFIGURATION CONSTANTS
// ------------------------------------------------------------------------------


// ==============================================================================
// INCLUDE FILES
// ------------------------------------------------------------------------------

// AVR Libc (see http://www.nongnu.org/avr-libc/)
#include <avr/io.h>				// include I/O definitions (port names, pin names, etc)
#include <avr/interrupt.h>		// include interrupt support
#include <avr/wdt.h>			// include watchdog timer support
#include <avr/eeprom.h>

// USB driver by Objective Development (see http://www.obdev.at/products/avrusb/index.html)
#include "usbdrv.h"

#include "midi_gnusb.h"			// the midi-gnusb library: setup and utility functions 


// ==============================================================================
// Global variables
// ------------------------------------------------------------------------------

// Arrays of keep track of sampled sensors and what data has already been sent via MIDI


// ------------------------------------------------------------------------------
// - What to do when we receive Note On Messages
// ------------------------------------------------------------------------------

void handleNoteOn(unsigned char note) {

}

// ------------------------------------------------------------------------------
// - What to do when we receive Note Off Messages
// ------------------------------------------------------------------------------

void handleNoteOff(unsigned char note) {
}



// ==============================================================================
// - main
// ------------------------------------------------------------------------------
int main(void)
{
	// ------------------------- Initialize Hardware
	
	
	unsigned char		channel = 0;
	unsigned int		wait;
	unsigned char		normal_mode;
	
	// PORTA: ANODES
	DDRA 	= 0xFF;
	PORTA 	= 0x00;	


	// PORTB: button
	DDRB 	= 0x00;
	PORTB 	= 0x02;
	
	// PORTC CATHODES
	DDRC 	= 0xFF;	
	PORTC 	= 0xFF; 
	
	// PORTD: gnusb stuff: USB, status leds, jumper
	initMidiGnusb();	// (see midi_gnusb.c)
	

	statusLedOn(StatusLed_Green);		// light green led to show we're up and running
	

	// ------------------------- Main Loop
	while(1) {
	
        wdt_reset();					// reset Watchdog timer - otherwise Watchdog will reset gnusb
		usbPoll();						// see if there's something going on on the usb bus
		
		normal_mode = PINB & (1<<1);

		
		if (!wait) {
			PORTA = 0x00;
			PORTC = 0xFF;
			PORTA = (1 << channel);
			if (normal_mode) {
				PORTC =	~(1 << (7-channel));
			} else {
				PORTC =	0x00;
			}
			channel++;
			channel %= 8;
		}
		
		wait++;
		if (normal_mode) {
			if (wait >= 1000) {wait = 0;}
		} else {
			if (wait >= 15000) {wait = 0;}
		}
	}
	return 0;
}

